package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.util.Misc;

public class InitAction implements ClientAction {

  // create Options object
  private final Options options = ClientOptions.createInitOptions();

  public static void init(final String jmxServiceUrl, final String jmxObjectName) {
    try {
      final RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      remoteDeployer.initialize();
    } catch (final Exception e) {
      throw new OrchestraRuntimeException("Exception during initialization", e);
    }
  }

  protected static void init(final CommandLine line) {
    final String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    final String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    InitAction.init(jmxServiceUrl, jmxObjectName);
    System.out.println("Orchestra is started and initialized");
  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    final CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(this.options, args);
    } catch (final ParseException exp) {
      // oops, something went wrong
      return false;
    }

    InitAction.init(line);

    return true;
  }

  public Options getOptions() {
    return this.options;
  }

  public String getDescription() {
    return "To initialize Orchestra Engine (redeploy WS after a crash)";
  }
}
