/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListProcessAction
implements ClientAction {
    private final Options options = ClientOptions.createListOptions();

    public static List<QName> list(String jmxServiceUrl, String jmxObjectName) {
        try {
            RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
            List<ProcessDefinition> processDefinitionDataList = remoteDeployer.findProcessDefinitions();
            ArrayList<QName> result = new ArrayList<QName>();
            for (ProcessDefinition processDefinitionData : processDefinitionDataList) {
                result.add(processDefinitionData.getQName());
            }
            return result;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    protected static void list(CommandLine line) {
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        List<QName> processNames = ListProcessAction.list(jmxServiceUrl, jmxObjectName);
        System.out.println("List of deployed processes :");
        for (QName name : processNames) {
            System.out.println(name);
        }
    }

    @Override
    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        ListProcessAction.list(line);
        return true;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public String getDescription() {
        return "To list deployed BPEL processes";
    }
}

