/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessResourcesRepository
implements Serializable {
    private static final long serialVersionUID = -67804473770091529L;
    protected Map<String, byte[]> resources = new HashMap<String, byte[]>();

    public Map<String, byte[]> getResources() {
        return this.resources;
    }

    public void addResource(URL url, String resourceName) {
        try {
            byte[] resourceBytes = Misc.getAllContentFrom(url);
            this.resources.put(resourceName, resourceBytes);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Problem when getting resource from url : " + url, e);
        }
    }

    public ClassLoader getResourcesClassLoader(ClassLoader parentClassLoader) {
        return new ResourceClassLoader(this.resources, parentClassLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceClassLoader
    extends ClassLoader {
        private final Map<String, byte[]> resources;

        public ResourceClassLoader(Map<String, byte[]> resources, ClassLoader parentClassLoader) {
            super(parentClassLoader);
            this.resources = resources;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            String resourceName = name.replace(".", "/") + ".class";
            byte[] b = this.resources.get(resourceName);
            if (b != null) {
                return this.defineClass(name, b, 0, b.length);
            }
            return super.findClass(name);
        }
    }
}

