package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ListInstanceAction implements ClientAction {

  // create Options object
  private final Options options = ClientOptions.createListInstanceOptions();

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    final CommandLineParser parser = new GnuParser();
    try {
      // parse the command line arguments
      parser.parse(this.options, args);
    } catch (final ParseException exp) {
      // oops, something went wrong
      return false;
    }

    return true;
  }

  public Options getOptions() {
    return this.options;
  }

  public String getDescription() {
    return "To list BPEL instances";
  }
}
