package org.ow2.orchestra.jmxclient;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.util.Misc;

public class GetProcessAction implements ClientAction {

  // create Options object
  private final Options options = ClientOptions.createGetProcessOptions();

  public static ProcessDefinition get(final String jmxServiceUrl, final String jmxObjectName, final QName processQName) {
    try {
      final RemoteDeployerMBean mbean = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      final List<ProcessDefinition> res = mbean.findProcessDefinitions(processQName, ProcessState.ACTIVE);
      if (res != null && !res.isEmpty()) {
        return res.get(0);
      }
      return null;
    } catch (final Exception e) {
      throw new OrchestraRuntimeException("Error while getting process info " + processQName.toString(), e);
    }
  }

  protected static void get(final CommandLine line) {
    QName processQName = null;
    final String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    final String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);
    if (line.hasOption(ClientOptions.PROCESS_QNAME_OPTION)) {
      processQName = QName.valueOf(line.getOptionValue(ClientOptions.PROCESS_QNAME_OPTION));
    }

    final ProcessDefinition recProc = GetProcessAction.get(jmxServiceUrl, jmxObjectName, processQName);
    System.out.println("Informations of the deployed processes :");
    if (recProc != null) {
      System.out.println(recProc.getQName());
    }
  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    final CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(this.options, args);
    } catch (final ParseException exp) {
      // oops, something went wrong
      return false;
    }

    GetProcessAction.get(line);

    return true;
  }

  public Options getOptions() {
    return this.options;
  }

  public String getDescription() {
    return "To get the informations of the deployed BPEL process";
  }
}
