package org.ow2.orchestra.jmxclient;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class StatusAction implements ClientAction {

  // create Options object
  private final Options options = ClientOptions.createStatusOptions();

  protected static void status(final CommandLine line) {
    final String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    final String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    final List<QName> processNames = ListProcessAction.list(jmxServiceUrl,
        jmxObjectName);

    System.out.println("Orchestra is started");
    System.out.println("List of deployed processes:");
    for (final QName name : processNames) {
      System.out.println(name);
    }

  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    final CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(this.options, args);
    } catch (final ParseException exp) {
      // oops, something went wrong
      return false;
    }

    StatusAction.status(line);

    return true;
  }

  public Options getOptions() {
    return this.options;
  }

  public String getDescription() {
    return "get Orchestra status";
  }
}
