/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.ProcessDefinition;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.deploy.DeployerManager;

/**
 * @author Tom Baeyens
 */
public class DeployCmd implements Command<ProcessDefinition> {

  private static final long serialVersionUID = 1L;

  protected Deployment deployment;

  public DeployCmd(Deployment deployment) {
    this.deployment = deployment;
  }

  public ProcessDefinition execute(Environment environment) throws Exception {
    ProcessDefinition processDefinition = deployment.getProcessDefinition();

    if (processDefinition != null) {
      DeployerManager deployerManager = environment.get(DeployerManager.class);
      if (deployerManager == null) {
        throw new PvmException("no " + DeployerManager.class.getName()
            + " configured");
      }

      // let the process parser managemer determine the process language
      // and handle the deployment
      deployerManager.deploy(deployment);
    }

    return processDefinition;
  }
}
