/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import java.util.Map;

import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.client.ClientExecution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.session.PvmDbSession;

/**
 * @author Tom Baeyens
 */
public class SignalCmd implements Command<Execution> {

  private static final long serialVersionUID = 1L;

  protected Long executionDbid;
  protected String executionId;
  protected String processDefinitionName;
  protected String executionKey;
  protected String signalName;
  protected Map<String, Object> parameters;

  // TODO REMOVE
  public SignalCmd(long executionDbid, String signalName,
      Map<String, Object> parameters) {
    this.executionDbid = executionDbid;
    this.signalName = signalName;
    this.parameters = parameters;
  }

  // TODO REMOVE
  public SignalCmd(String processDefinitionName, String executionKey,
      String signalName, Map<String, Object> parameters) {
    if (processDefinitionName == null) {
      throw new PvmException("processDefinitionName is null");
    }
    if (executionKey == null) {
      throw new PvmException("executionKey is null");
    }
    this.executionKey = executionKey;
    this.signalName = signalName;
    this.parameters = parameters;
  }

  public SignalCmd(String executionKey, String signalName,
      Map<String, Object> parameters) {
    if (executionKey == null) {
      throw new PvmException("executionKey is null");
    }
    this.executionKey = executionKey;
    this.signalName = signalName;
    this.parameters = parameters;
  }

  public SignalCmd(String executionId) {
    // TODO Auto-generated constructor stub
  }

  public Execution execute(Environment environment) throws Exception {
    ClientExecution execution = null;

    PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
    if (executionDbid != null) {
      execution = pvmDbSession.get(ExecutionImpl.class, executionDbid);
      if (execution == null) {
        throw new PvmException("execution " + executionDbid + " does not exist");
      }
    } else {
      execution = pvmDbSession.findExecutionById(executionKey);
      if (execution == null) {
        throw new PvmException("execution " + executionKey + " does not exist");
      }
    }

    execution.signal(signalName, parameters);

    return execution;
  }
}
