/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;



/**
 * @author Tom Baeyens
 * @author Guillaume Porcher
 *
 */
public interface JobExecutor {

  /**
   * starts the {@link org.ow2.orchestra.pvm.internal.jobexecutor.pvm.DispatcherThread}
   * and {@link org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThread}s for this
   * jobImpl executor
   */
  void start();

  /**
   * stops with join set to false.
   *
   * @see #stop(boolean)
   */
  void stop();

  /**
   * signals to all threads managed by this jobImpl executor to stop. Stopping
   * the dispatcher thread is blocking till the dispatcher is no more alive. If
   * join is set to true, this method will block until all jobImpl executor
   * threads are joined and actually dead. If join is false, the jobImpl
   * executor threads are only told to stop, without waiting till they are
   * actually stopped. It may be that jobImpl executor threads are in the middle
   * of executing a jobImpl and they may finish after this method returned.
   */
  void stop(final boolean join);

  /** signals jobExecutor that a job has been added */
  void jobWasAdded();

  /** returns JobExecutor name */
  String getName();

  /** returns true if this JobExecutor is started */
  boolean isActive();

}
