/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.session.MessageSession;

/**
 * @author Tom Baeyens
 */
public class JobExecutorMessageSession implements MessageSession {

  private static final Log LOG = Log.getLog(JobExecutorMessageSession.class.getName());

  /* injected */
  private JobDbSession jobDbSession;

  /* injected */
  private Transaction transaction;

  private boolean isNotificationAdded;

  public void send(final MessageImpl< ? > message) {
    JobExecutorMessageSession.LOG.debug("sending message "
        + ReflectUtil.getUnqualifiedClassName(message.getClass()));

    this.jobDbSession.save(message);

    if (!this.isNotificationAdded) {
      this.isNotificationAdded = true;

      // notify the job executor after the transaction is completed
      JobExecutorMessageSession.LOG.trace("registering job executor notifier with " + this.transaction);
      final JobExecutor jobExecutor = Environment.getCurrent().get(JobExecutor.class);
      if (jobExecutor == null) {
        throw new PvmException("no job executor configured to execute "
            + message);
      }
      this.transaction
          .registerSynchronization(new JobAddedNotification(jobExecutor));
    }
  }
}
