/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.pvm.internal.jobexecutor.jdk;

import java.util.Collection;

import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExceptionHandler;
import org.ow2.orchestra.pvm.internal.log.Log;

/**
 * @author Guillaume Porcher
 *
 * Runnable task to execute a job in an ExecutorService
 */
public class JobExecutorTask implements Runnable {

  private static final Log LOG = Log.getLog(JobExecutorTask.class.getName());

  private final CommandService commandService;
  private final Collection<Long> jobDbids;

  public JobExecutorTask(final CommandService commandService, final Collection<Long> jobDbids) {
    this.commandService = commandService;
    this.jobDbids = jobDbids;
  }

  public void run() {
    JobExecutorTask.LOG.debug("job executor task executing job(s) " + this.jobDbids);
    for (final Long jobDbid : this.jobDbids) {
      try {
        this.commandService.execute(new ExecuteJobCmd(jobDbid));
      } catch (final Throwable e) {
        JobExecutorTask.LOG.error("exception while executing '" + jobDbid + "'", e);
        this.commandService.execute(new JobExceptionHandler(jobDbid, e, this.commandService));
      }
    }
  }

}
