/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.Collection;

import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.pvm.internal.log.Log;

/**
 * this thread is responsible for acquiring jobs in the jobImpl that need to be
 * executed and then let the JobExecutor dispatch the acquired ids to one of the
 * JobExecutorThreads in the pool. There is only one dispatcher thread per
 * JobExecutor.
 *
 * @author Tom Baeyens, Guillaume Porcher
 */
public class DispatcherThread extends AbstractDispatcherThread {

  private static final Log LOG = Log.getLog(DispatcherThread.class.getName());

  private final PvmJobExecutor jobExecutor;

  DispatcherThread(final PvmJobExecutor jobExecutor) {
    this(jobExecutor, "DispatcherThread");
  }

  DispatcherThread(final PvmJobExecutor jobExecutor, final String name) {
    super(name);
    this.jobExecutor = jobExecutor;
  }

  @Override
  protected void putAcquiredJobDbidsOnQueue(Collection<Long> acquiredJobDbids) {
    DispatcherThread.LOG.debug("pushing jobs on the queue " + acquiredJobDbids);
    while (acquiredJobDbids != null) {
      try {
        this.jobExecutor.getJobDbidsQueue().put(acquiredJobDbids);
        DispatcherThread.LOG.trace("jobs " + acquiredJobDbids + " were put on the queue");
        acquiredJobDbids = null;
      } catch (final InterruptedException e) {
        DispatcherThread.LOG
            .trace("putting acquired jobImpl dbids got interrupted. retrying...");
      }
    }
  }

  @Override
  public PvmJobExecutor getJobExecutor() {
    return this.jobExecutor;
  }
}
