package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

import org.ow2.orchestra.pvm.internal.log.Log;


public class DynamicJobExecutorThreadPool implements JobExecutorThreadPool {

  private ThreadFactory threadFactory;
  private ExecutorService executorService;
  private final PvmJobExecutor jobExecutor;

  public DynamicJobExecutorThreadPool(final PvmJobExecutor jobExecutor) {
    this.jobExecutor = jobExecutor;
  }

  public void start() {
    this.threadFactory = new JobExecutorThreadFactory(this.jobExecutor);
    this.executorService = Executors.newCachedThreadPool(this.threadFactory);
  }

  public void stop() {
    this.stop(false);
  }

  public void stop(final boolean join) {
    /*for (JobExecutorThread jobExecutorThread : executorService.invokeAll(tasks)) {
      jobExecutorThread.stop(join);
    }*/
    this.executorService.shutdown();
  }

  private static class JobExecutorThreadFactory implements ThreadFactory {
    private final PvmJobExecutor jobExecutor;
    private int threadNb = 0;
    private static final Log LOG = Log.getLog(JobExecutorThreadFactory.class.getName());
    public JobExecutorThreadFactory(final PvmJobExecutor jobExecutor) {
      this.jobExecutor = jobExecutor;
    }
    public Thread newThread(final Runnable r) {
      JobExecutorThreadFactory.LOG.debug("Creating a new JobExecutorThread from " + this.getClass());
      return new JobExecutorThread(this.getNextThreadName(), this.jobExecutor);
    }
    protected String getNextThreadName() {
      return "JobExecutorThread" + this.getNextThreadNb();
    }
    private synchronized int getNextThreadNb() {
      return this.threadNb++;
    }
  }
}
