package org.ow2.orchestra.pvm.internal.lob;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BlobStrategyChopped implements BlobStrategy {

  private static final int CHOP_SIZE = 1024;

  public void set(final byte[] bytes, final Blob blob) {
    blob.setChops(this.chop(bytes));
  }

  public byte[] get(final Blob blob) {
    return this.glue(blob.getChops());
  }

  public List<byte[]> chop(final byte[] bytes) {
    List<byte[]> chops = null;
    if ((bytes != null) && (bytes.length > 0)) {
      chops = new ArrayList<byte[]>();
      int index = 0;
      while ((bytes.length - index) > BlobStrategyChopped.CHOP_SIZE) {
        final byte[] byteBlock = new byte[BlobStrategyChopped.CHOP_SIZE];
        System.arraycopy(bytes, index, byteBlock, 0, BlobStrategyChopped.CHOP_SIZE);
        chops.add(byteBlock);
        index += BlobStrategyChopped.CHOP_SIZE;
      }
      final byte[] byteBlock = new byte[bytes.length - index];
      System.arraycopy(bytes, index, byteBlock, 0, bytes.length - index);
      chops.add(byteBlock);
    }
    return chops;
  }

  public byte[] glue(final List<byte[]> chops) {
    byte[] bytes = null;
    if (chops != null) {
      final Iterator<byte[]> iter = chops.iterator();
      while (iter.hasNext()) {
        final byte[] byteBlock = iter.next();
        if (bytes == null) {
          bytes = byteBlock;
        } else {
          final byte[] oldValue = bytes;
          bytes = new byte[bytes.length + byteBlock.length];
          System.arraycopy(oldValue, 0, bytes, 0, oldValue.length);
          System.arraycopy(byteBlock, 0, bytes, oldValue.length,
              byteBlock.length);
        }
      }
    }
    return bytes;
  }
}
