/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.jms.JmsMessageSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutorMessageSession;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.JndiDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.TransactionRefDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.pvm.session.DbSession;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/**
 * parses a descriptor for creating a {@link org.ow2.orchestra.pvm.session.MessageSession}.
 *
 * See schema docs for more details.
 *
 * @author Tom Baeyens
 */
public class MessageSessionBinding extends WireDescriptorBinding {

  public MessageSessionBinding() {
    super("message-session");
  }

  public Object parse(final Element element, final Parse parse, final Parser parser) {
    final ObjectDescriptor objectDescriptor = new ObjectDescriptor();

    final String target = XmlUtil.attribute(element, "target");
    if ("jms".equals(target)) {
      objectDescriptor.setClassName(JmsMessageSession.class.getName());
      objectDescriptor.addInjection("dbSession", new ContextTypeRefDescriptor(
          DbSession.class));

      if (element.hasAttribute("session-jndi")) {
        final String jmsSessionJndiName = element.getAttribute("session-jndi");
        final JndiDescriptor jndiDescriptor = new JndiDescriptor(jmsSessionJndiName);
        objectDescriptor.addInjection("jmsSession", jndiDescriptor);
      } else {
        parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element)
            + " session-jndi=\"...\" is required when target=\"jms\"");
      }

      if (element.hasAttribute("destination-jndi")) {
        final String jmsDestinationJndiName = element
            .getAttribute("destination-jndi");
        final JndiDescriptor jndiDescriptor = new JndiDescriptor(
            jmsDestinationJndiName);
        objectDescriptor.addInjection("jmsDestination", jndiDescriptor);
      } else {
        parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element)
            + " destination-jndi=\"...\" is required when target=\"jms\"");
      }

    } else {
      objectDescriptor.setClassName(JobExecutorMessageSession.class.getName());
      objectDescriptor.addInjection("transaction",
          new TransactionRefDescriptor());
      objectDescriptor.addInjection("jobDbSession", new ContextTypeRefDescriptor(
          JobDbSession.class));
    }

    return objectDescriptor;
  }
}
