/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.ejb.EnterpriseTimerSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutorTimerSession;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.EnvironmentTypeRefDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.TransactionRefDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/**
 * parses a descriptor for creating a {@link org.ow2.orchestra.pvm.session.TimerSession}.
 *
 * See schema docs for more details.
 *
 * @author Tom Baeyens, Pascal Verdage
 */
public class TimerSessionBinding extends WireDescriptorBinding {

  public TimerSessionBinding() {
    super("timer-session");
  }

  public Object parse(final Element element, final Parse parse, final Parser parser) {
    final ObjectDescriptor objectDescriptor = new ObjectDescriptor();

    final String target = XmlUtil.attribute(element, "target");

    if ((target != null) && ("ejb".equalsIgnoreCase(target))) {
      objectDescriptor.setClassName(EnterpriseTimerSession.class.getName());

    } else {
      // wire the JobExecutorTimerSession
      objectDescriptor.setClassName(JobExecutorTimerSession.class.getName());

      // inject fields
      objectDescriptor.addInjection("transaction",
          new TransactionRefDescriptor());
      objectDescriptor.addInjection("jobExecutor",
          new EnvironmentTypeRefDescriptor(JobExecutor.class));
      objectDescriptor.addInjection("jobDbSession",
          new ContextTypeRefDescriptor(JobDbSession.class));
    }

    return objectDescriptor;
  }
}
