package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.wire.WireContext;

/**
 * the {@link EnvironmentFactory} of the current {@link WireContext}.
 *
 * @author Tom Baeyens
 * @author Guillaume Porcher (documentation)
 */
public class EnvironmentFactoryDescriptor extends AbstractDescriptor {

  private static final long serialVersionUID = 1L;

  private final EnvironmentFactory environmentFactory;

  public EnvironmentFactoryDescriptor(final EnvironmentFactory environmentFactory) {
    this.environmentFactory = environmentFactory;
  }

  public Object construct(final WireContext wireContext) {
    return this.environmentFactory;
  }
}
