/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import java.util.Map;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.client.ClientExecution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalCmd
implements Command<Execution> {
    private static final long serialVersionUID = 1L;
    protected Long executionDbid;
    protected String executionId;
    protected String processDefinitionName;
    protected String executionKey;
    protected String signalName;
    protected Map<String, Object> parameters;

    public SignalCmd(long executionDbid, String signalName, Map<String, Object> parameters) {
        this.executionDbid = executionDbid;
        this.signalName = signalName;
        this.parameters = parameters;
    }

    public SignalCmd(String processDefinitionName, String executionKey, String signalName, Map<String, Object> parameters) {
        if (processDefinitionName == null) {
            throw new PvmException("processDefinitionName is null");
        }
        if (executionKey == null) {
            throw new PvmException("executionKey is null");
        }
        this.executionKey = executionKey;
        this.signalName = signalName;
        this.parameters = parameters;
    }

    public SignalCmd(String executionKey, String signalName, Map<String, Object> parameters) {
        if (executionKey == null) {
            throw new PvmException("executionKey is null");
        }
        this.executionKey = executionKey;
        this.signalName = signalName;
        this.parameters = parameters;
    }

    public SignalCmd(String executionId) {
    }

    @Override
    public Execution execute(Environment environment) throws Exception {
        ClientExecution execution = null;
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        if (this.executionDbid != null) {
            execution = pvmDbSession.get(ExecutionImpl.class, this.executionDbid);
            if (execution == null) {
                throw new PvmException("execution " + this.executionDbid + " does not exist");
            }
        } else {
            execution = pvmDbSession.findExecutionById(this.executionKey);
            if (execution == null) {
                throw new PvmException("execution " + this.executionKey + " does not exist");
            }
        }
        execution.signal(this.signalName, this.parameters);
        return execution;
    }
}

