/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import java.util.Map;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.client.ClientProcessDefinition;
import org.ow2.orchestra.pvm.client.ClientProcessInstance;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.VariablesCmd;
import org.ow2.orchestra.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartExecutionCmd
extends VariablesCmd<Execution> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String executionKey;

    public StartExecutionCmd(String processDefinitionId, Map<String, Object> variables, String executionKey) {
        this.processDefinitionId = processDefinitionId;
        this.variables = variables;
        this.executionKey = executionKey;
    }

    @Override
    public Execution execute(Environment environment) throws Exception {
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        ClientProcessDefinition processDefinition = null;
        processDefinition = pvmDbSession.findProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new PvmException("no process definition with id '" + this.processDefinitionId + "'");
        }
        ClientProcessInstance processInstance = processDefinition.createProcessInstance(this.executionKey);
        processInstance.setVariables(this.variables);
        processInstance.begin();
        pvmDbSession.save(processInstance);
        return processInstance;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionId = processDefinitionKey;
    }

    public String getExecutionKey() {
        return this.executionKey;
    }

    public void setExecutionKey(String executionKey) {
        this.executionKey = executionKey;
    }
}

