/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.transaction.Synchronization;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExceptionHandler
implements Synchronization,
Command<Object> {
    private static final Log LOG = Log.getLog(JobExceptionHandler.class.getName());
    private static final long serialVersionUID = 1L;
    protected CommandService commandService;
    protected long jobDbid;
    protected Throwable exception;

    public JobExceptionHandler(long jobDbid, Throwable exception, CommandService commandService) {
        this.commandService = commandService;
        this.jobDbid = jobDbid;
        this.exception = exception;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        this.commandService.execute(this);
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        LOG.debug("handling jobImpl " + this.jobDbid + " exception: " + this.exception.getMessage());
        JobDbSession session = environment.get(JobDbSession.class);
        if (session == null) {
            throw new PvmException("no job-session configured to handle job");
        }
        JobImpl job = session.get(JobImpl.class, this.jobDbid);
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        if (job != null) {
            int decrementedRetries = job.getRetries() - 1;
            LOG.debug("decrementing retries to " + decrementedRetries + " for " + job);
            job.setRetries(decrementedRetries);
            job.setException(sw.toString());
            LOG.debug("unlocking " + job);
            job.setLockOwner(null);
            job.setLockExpirationTime(null);
            Transaction transaction = environment.get(Transaction.class);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (transaction != null && jobExecutor != null) {
                LOG.trace("registering job executor notifier with " + transaction);
                transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
            }
        }
        return null;
    }
}

