/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.jdk;

import java.util.Collection;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExceptionHandler;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorTask
implements Runnable {
    private static final Log LOG = Log.getLog(JobExecutorTask.class.getName());
    private final CommandService commandService;
    private final Collection<Long> jobDbids;

    public JobExecutorTask(CommandService commandService, Collection<Long> jobDbids) {
        this.commandService = commandService;
        this.jobDbids = jobDbids;
    }

    @Override
    public void run() {
        LOG.debug("job executor task executing job(s) " + this.jobDbids);
        for (Long jobDbid : this.jobDbids) {
            try {
                this.commandService.execute(new ExecuteJobCmd(jobDbid));
            }
            catch (Throwable e) {
                LOG.error("exception while executing '" + jobDbid + "'", e);
                this.commandService.execute(new JobExceptionHandler(jobDbid, e, this.commandService));
            }
        }
    }
}

