/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThread;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThreadPool;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

public class DynamicJobExecutorThreadPool
implements JobExecutorThreadPool {
    private ThreadFactory threadFactory;
    private ExecutorService executorService;
    private final PvmJobExecutor jobExecutor;

    public DynamicJobExecutorThreadPool(PvmJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void start() {
        this.threadFactory = new JobExecutorThreadFactory(this.jobExecutor);
        this.executorService = Executors.newCachedThreadPool(this.threadFactory);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean join) {
        this.executorService.shutdown();
    }

    private static class JobExecutorThreadFactory
    implements ThreadFactory {
        private final PvmJobExecutor jobExecutor;
        private int threadNb = 0;
        private static final Log LOG = Log.getLog(JobExecutorThreadFactory.class.getName());

        public JobExecutorThreadFactory(PvmJobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
        }

        public Thread newThread(Runnable r) {
            LOG.debug("Creating a new JobExecutorThread from " + this.getClass());
            return new JobExecutorThread(this.getNextThreadName(), this.jobExecutor);
        }

        protected String getNextThreadName() {
            return "JobExecutorThread" + this.getNextThreadNb();
        }

        private synchronized int getNextThreadNb() {
            return this.threadNb++;
        }
    }
}

