/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExceptionHandler;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

public class JobExecutorThread
extends Thread {
    private static final Log LOG = Log.getLog(JobExecutorThread.class.getName());
    private final PvmJobExecutor jobExecutor;
    private boolean isActive = true;

    public JobExecutorThread(String name, PvmJobExecutor jobExecutor) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.info("starting...");
        try {
            BlockingQueue<Collection<Long>> queue = this.jobExecutor.getJobDbidsQueue();
            if (queue == null) {
                LOG.debug("no queue to take jobs from");
            } else {
                while (this.isActive) {
                    try {
                        LOG.trace("taking jobs from queue");
                        Collection<Long> jobDbids = null;
                        jobDbids = queue.take();
                        LOG.debug("took job(s) " + jobDbids + " from queue");
                        for (Long jobDbid : jobDbids) {
                            CommandService commandService = this.jobExecutor.getCommandExecutor();
                            try {
                                commandService.execute(new ExecuteJobCmd(jobDbid));
                            }
                            catch (Throwable e) {
                                LOG.error("exception occured in job " + jobDbid, e);
                                commandService.execute(new JobExceptionHandler(jobDbid, e, commandService));
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.trace("waiting for acquired jobs got interrupted");
                    }
                    catch (Exception e) {
                        LOG.error("exception in job executor thread", e);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            LOG.info(this.getName() + " leaves cyberspace");
        }
    }

    public void deactivate() {
        this.stop(false);
    }

    public void stop(boolean join) {
        if (this.isActive) {
            LOG.trace("deactivating " + this.getName());
            this.isActive = false;
            this.interrupt();
            if (join) {
                while (this.isAlive()) {
                    try {
                        this.join();
                    }
                    catch (InterruptedException e) {
                        LOG.trace("joining " + this.getName() + " got interrupted");
                    }
                }
            }
        } else {
            LOG.trace("ignoring deactivate: " + this.getName() + " is not active");
        }
    }
}

