/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.jms.JmsMessageSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutorMessageSession;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.JndiDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.TransactionRefDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.pvm.session.DbSession;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class MessageSessionBinding
extends WireDescriptorBinding {
    public MessageSessionBinding() {
        super("message-session");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        String target = XmlUtil.attribute((Element)element, (String)"target");
        if ("jms".equals(target)) {
            JndiDescriptor jndiDescriptor;
            objectDescriptor.setClassName(JmsMessageSession.class.getName());
            objectDescriptor.addInjection("dbSession", new ContextTypeRefDescriptor(DbSession.class));
            if (element.hasAttribute("session-jndi")) {
                String jmsSessionJndiName = element.getAttribute("session-jndi");
                jndiDescriptor = new JndiDescriptor(jmsSessionJndiName);
                objectDescriptor.addInjection("jmsSession", jndiDescriptor);
            } else {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName((Element)element) + " session-jndi=\"...\" is required when target=\"jms\"");
            }
            if (element.hasAttribute("destination-jndi")) {
                String jmsDestinationJndiName = element.getAttribute("destination-jndi");
                jndiDescriptor = new JndiDescriptor(jmsDestinationJndiName);
                objectDescriptor.addInjection("jmsDestination", jndiDescriptor);
            } else {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName((Element)element) + " destination-jndi=\"...\" is required when target=\"jms\"");
            }
        } else {
            objectDescriptor.setClassName(JobExecutorMessageSession.class.getName());
            objectDescriptor.addInjection("transaction", new TransactionRefDescriptor());
            objectDescriptor.addInjection("jobDbSession", new ContextTypeRefDescriptor(JobDbSession.class));
        }
        return objectDescriptor;
    }
}

