package org.ow2.orchestra.pvm.internal.job;

import java.io.Serializable;
import java.util.Date;

import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.job.Job;

public abstract class JobImpl<T> implements Command<T>, Serializable, Job {

  private static final long serialVersionUID = 1L;
  // private static final DateFormat dateFormat = new
  // SimpleDateFormat("dd-MMM-yyyy HH:mm:ss,SSS");

  protected long dbid;
  protected int dbversion;

  /**
   * date until which the command should not be executed this date is set to the
   * current time It should be modified only for timers Warning: if you modify
   * this, be sure to wake the JobExecutor when the jobImpl is supposed to be
   * executed
   */
  protected Date dueDate = new Date();

  /** suspended jobs will not execute. */
  protected boolean isSuspended;

  /** the execution (if any) for this jobImpl */
  protected ExecutionImpl execution;

  /** the process instance */
  protected ExecutionImpl processInstance;

  // execution members

  /**
   * specifies if this jobImpl can be executed concurrently with other jobs for
   * the same execution.
   */
  protected boolean isExclusive;

  /** name of the jobImpl executor name that has locked this jobImpl. */
  protected String lockOwner;

  /** the time the lock on this jobImpl expires. */
  protected Date lockExpirationTime;

  /** stack trace of the exception that occurred during command execution. */
  protected String exception;

  /**
   * number of attempts left to try. Should be decremented each time an
   * exception occurs during command execution.
   */
  protected int retries = 3;
  protected boolean isDefaultRetries = true;

  /** a command that can be used as the behaviour of this job */
  protected Descriptor commandDescriptor;

  public JobImpl() {
  }

  public void setExecution(final ExecutionImpl execution) {
    this.execution = execution;
    this.processInstance = execution.getProcessInstance();
  }

  public long getDbid() {
    return this.dbid;
  }

  public void setDbid(final long id) {
    this.dbid = id;
  }

  public String getLockOwner() {
    return this.lockOwner;
  }

  public boolean isSuspended() {
    return this.isSuspended;
  }

  public Date getDueDate() {
    return this.dueDate;
  }

  public void setDueDate(final Date dueDate) {
    this.dueDate = dueDate;
  }

  public String getException() {
    return this.exception;
  }

  public int getRetries() {
    return this.retries;
  }

  public boolean isExclusive() {
    return this.isExclusive;
  }

  public ExecutionImpl getExecution() {
    return this.execution;
  }

  public void setException(final String exception) {
    this.exception = exception;
  }

  public void setExclusive(final boolean isExclusive) {
    this.isExclusive = isExclusive;
  }

  public void setLockOwner(final String jobExecutorName) {
    this.lockOwner = jobExecutorName;
  }

  public void setRetries(final int retries) {
    this.retries = retries;
    this.isDefaultRetries = false;
  }

  public void setSuspended(final boolean isSuspended) {
    this.isSuspended = isSuspended;
  }

  public ExecutionImpl getProcessInstance() {
    return this.processInstance;
  }

  public Date getLockExpirationTime() {
    return this.lockExpirationTime;
  }

  public void setLockExpirationTime(final Date lockExpirationTime) {
    this.lockExpirationTime = lockExpirationTime;
  }

  public Descriptor getCommandDescriptor() {
    return this.commandDescriptor;
  }

  public void setCommandDescriptor(final Descriptor commandDescriptor) {
    this.commandDescriptor = commandDescriptor;
  }

  /**
   * @return the isDefaultRetries
   */
  public boolean isDefaultRetries() {
    return this.isDefaultRetries;
  }
}
