/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.type;

import java.io.Serializable;

import org.ow2.orchestra.pvm.internal.util.ReflectUtil;

/**
 * a variable type.
 *
 * @author Tom Baeyens
 */
public class Type implements Serializable {

  private static final long serialVersionUID = 1L;

  protected String name;
  protected Converter converter;
  protected Class< ? > variableClass;

  @Override
  public String toString() {
    if (this.name != null) {
      return this.name;
    }
    final StringBuffer buffer = new StringBuffer();
    if (this.converter != null) {
      buffer.append(this.converter.toString());
      buffer.append("-->");
    }
    if (this.variableClass != null) {
      buffer.append(ReflectUtil.getUnqualifiedClassName(this.variableClass));
    } else {
      buffer.append("undefined");
    }
    return buffer.toString();
  }

  public Converter getConverter() {
    return this.converter;
  }

  public void setConverter(final Converter converter) {
    this.converter = converter;
  }

  public Class< ? > getVariableClass() {
    return this.variableClass;
  }

  public void setVariableClass(final Class< ? > variableClass) {
    this.variableClass = variableClass;
  }

  public String getName() {
    return this.name;
  }

  public void setName(final String name) {
    this.name = name;
  }
}
