/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.internal.svc.RetryInterceptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;

/**
 * @author Tom Baeyens
 */
public class RetryInterceptorDescriptor extends AbstractDescriptor {

  private static final long serialVersionUID = 1L;

  private final RetryInterceptor retryInterceptor = this.createRetryInterceptor();

  protected RetryInterceptor createRetryInterceptor() {
    return new RetryInterceptor();
  }
  public Object construct(final WireContext wireContext) {
    return this.retryInterceptor;
  }

  public void setRetries(final int retries) {
    this.retryInterceptor.setRetries(retries);
  }

  public void setDelay(final long delay) {
    this.retryInterceptor.setDelay(delay);
  }

  public void setDelayFactor(final int delayFactor) {
    this.retryInterceptor.setDelayFactor(delayFactor);
  }

}
