/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.model;

import java.util.Date;

/**
 * a free text comment that can be made to an {@link org.ow2.orchestra.pvm.Execution} or a task.
 *
 * This class also supports threaded discussions with the {@link #getParent()
 * parent}-{@link #getComments() child} relation.
 *
 * @author Tom Baeyens
 */
public interface Comment extends Discussable {

  /** the meaningless database primary key */
  long getDbid();

  /**
   * the id of the user that made this comment. The term actorId is an abstract
   * reference to an entity in an external identity component.
   */
  String getUserId();

  /**
   * the actual message. Both plain text as well as HTML can be stored as the
   * message.
   */
  String getMessage();

  /** time that specifies when the comment was made */
  Date getTime();
}