/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.processlog;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Tom Baeyens
 */
public class ProcessLogProperty {

  protected String name;
  protected String value;
  protected List<ProcessLogProperty> properties;

  public ProcessLogProperty(String name) {
    this.name = name;
  }

  public ProcessLogProperty(String name, String value) {
    this.name = name;
    this.value = value;
  }

  public ProcessLogProperty createProperty(String name) {
    return createProperty(name, null);
  }

  public ProcessLogProperty createProperty(String name, String value) {
    ProcessLogProperty property = new ProcessLogProperty(name, value);
    addProperty(property);
    return property;
  }

  public void addProperty(ProcessLogProperty property) {
    if (properties == null) {
      properties = new ArrayList<ProcessLogProperty>();
    }
    properties.add(property);
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public List<ProcessLogProperty> getProperties() {
    return properties;
  }

  public void setProperties(List<ProcessLogProperty> properties) {
    this.properties = properties;
  }
}
