/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindExecutionCmd
implements Command<Execution> {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String processDefinitionName;
    protected String executionKey;

    public FindExecutionCmd(String processDefinitionName, String executionKey) {
        if (processDefinitionName == null) {
            throw new PvmException("processDefinitionName is null");
        }
        this.processDefinitionName = processDefinitionName;
        if (executionKey == null) {
            throw new PvmException("executionKey is null");
        }
        this.executionKey = executionKey;
    }

    public FindExecutionCmd(String executionId) {
        if (executionId == null) {
            throw new PvmException("executionId is null");
        }
        this.executionId = executionId;
    }

    @Override
    public Execution execute(Environment environment) {
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        if (this.executionId != null) {
            return pvmDbSession.findExecutionById(this.executionId);
        }
        return pvmDbSession.findExecutionByKey(this.processDefinitionName, this.executionKey);
    }
}

