/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireJobsCmd
implements Command<Collection<Long>> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(AcquireJobsCmd.class.getName());
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    private final String lockOwnerName;
    private final int lockMillis;

    public AcquireJobsCmd(String lockOwnerName, int lockMillis) {
        this.lockOwnerName = lockOwnerName;
        this.lockMillis = lockMillis;
    }

    @Override
    public Collection<Long> execute(Environment environment) {
        ArrayList<Long> acquiredJobDbids = new ArrayList<Long>();
        ArrayList acquiredJobs = new ArrayList();
        JobDbSession jobDbSession = environment.get(JobDbSession.class);
        LOG.debug("start querying first acquirable jobImpl...");
        JobImpl<?> job = jobDbSession.findFirstAcquirableJob();
        if (job != null) {
            if (job.isExclusive()) {
                LOG.trace("exclusive acquirable jobImpl found (" + job + "). querying for other exclusive jobs to lock them all in one tx...");
                List<JobImpl<?>> otherExclusiveJobs = jobDbSession.findExclusiveJobs(job.getProcessInstance());
                acquiredJobs.addAll(otherExclusiveJobs);
            } else {
                acquiredJobs.add(job);
            }
            for (JobImpl jobImpl : acquiredJobs) {
                long lockExpirationTime = System.currentTimeMillis() + (long)this.lockMillis;
                LOG.trace("trying to obtain a lock for '" + jobImpl + "' with exp " + this.timeFormat.format(new Date(lockExpirationTime)));
                jobImpl.setLockExpirationTime(new Date(lockExpirationTime));
                jobImpl.setLockOwner(this.lockOwnerName);
                acquiredJobDbids.add(jobImpl.getDbid());
            }
        } else {
            LOG.trace("no acquirable jobs in jobImpl table");
        }
        LOG.debug("locking jobs " + acquiredJobDbids);
        return acquiredJobDbids;
    }
}

