/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.spring;

import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.spring.CommandTransactionCallback;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCommandService
implements CommandService {
    private TransactionTemplate transactionTemplate;
    private EnvironmentFactory environmentFactory;

    public void setEnvironmentFactory(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    public void setTransactionManager(HibernateTransactionManager transactionManager) {
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
    }

    @Override
    public <T> T execute(Command<T> command) {
        return (T)this.transactionTemplate.execute(new CommandTransactionCallback<T>(command, this.environmentFactory));
    }
}

