/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.tx;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.svc.Interceptor;
import org.ow2.orchestra.pvm.internal.tx.StandardTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTransactionInterceptor
extends Interceptor {
    private static final Log LOG = Log.getLog(StandardTransactionInterceptor.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new PvmException("no environment for managing hibernate transaction");
        }
        StandardTransaction standardTransaction = environment.get(StandardTransaction.class);
        if (standardTransaction == null) {
            throw new PvmException("no standard-transaction in environment");
        }
        standardTransaction.begin();
        try {
            T t = this.next.execute(command);
            return t;
        }
        catch (RuntimeException e) {
            LOG.error("Failed executing command " + command, e);
            standardTransaction.setRollbackOnly();
            throw e;
        }
        finally {
            standardTransaction.complete();
        }
    }
}

