/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import java.util.Map;

import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.client.ClientProcessDefinition;
import org.ow2.orchestra.pvm.client.ClientProcessInstance;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.session.PvmDbSession;

/**
 * @author Tom Baeyens
 */
public class StartExecutionInLatestCmd extends VariablesCmd<Execution> {

  private static final long serialVersionUID = 1L;

  protected String processDefinitionName;
  protected String executionKey;

  public StartExecutionInLatestCmd(final String processDefinitionName,
      final Map<String, Object> variables, final String executionKey) {
    this.processDefinitionName = processDefinitionName;
    this.variables = variables;
    this.executionKey = executionKey;
  }

  public Execution execute(final Environment environment) {
    final PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);

    ClientProcessDefinition processDefinition = null;

    processDefinition = pvmDbSession
        .findLatestProcessDefinitionByName(this.processDefinitionName);
    if (processDefinition == null) {
      throw new PvmException("no process definition with name '"
          + this.processDefinitionName + "'");
    }

    final ClientProcessInstance processInstance = processDefinition
        .createProcessInstance(this.executionKey);
    processInstance.setVariables(this.variables);
    processInstance.begin();

    pvmDbSession.save(processInstance);
    return processInstance;
  }

  public String getProcessDefinitionName() {
    return this.processDefinitionName;
  }

  public void setProcessDefinitionName(final String processName) {
    this.processDefinitionName = processName;
  }

  public String getExecutionKey() {
    return this.executionKey;
  }

  public void setExecutionKey(final String executionKey) {
    this.executionKey = executionKey;
  }
}
