/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.env;

import java.util.Set;

import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.env.Context;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;

public class ExecutionContext implements Context {

  private final ExecutionImpl execution;

  public String getName() {
    return "execution";
  }

  public ExecutionContext(final Execution execution) {
    this.execution = (ExecutionImpl) execution;
  }

  public Object get(final String key) {
    return this.execution.getVariable(key);
  }

  public boolean has(final String key) {
    return this.execution.hasVariable(key);
  }

  public Set<String> keys() {
    return this.execution.getVariableKeys();
  }

  public Object set(final String key, final Object value) {
    this.execution.setVariable(key, value);
    return null;
  }

  public <T> T get(final Class<T> type) {
    return null;
  }
}
