package org.ow2.orchestra.pvm.internal.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Properties;

import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;

public class ExecutionType implements UserType, ParameterizedType {

  private static final long serialVersionUID = 1L;
  private static final Log LOG = Log.getLog(ExecutionType.class.getName());

  private final int[] sqlTypes = new int[] { Types.VARCHAR };

  protected String processResource;
  protected ProcessDefinitionImpl processDefinition;

  public void setParameterValues(final Properties properties) {
  }

  public int[] sqlTypes() {
    return this.sqlTypes;
  }

  // JDBC - object translation

  public Object nullSafeGet(final ResultSet rs, final String[] names, final Object owner) throws SQLException {
    final ExecutionImpl execution = this.createExecution(owner);
    final String nodeName = rs.getString(names[0]);
    final NodeImpl node = execution.getProcessDefinition().getNode(
        nodeName);
    execution.setNode(node);
    execution.setState(Execution.STATE_ACTIVE);
    return execution;
  }

  private ExecutionImpl createExecution(final Object owner) {
    final ExecutionImpl execution = new ExecutionImpl();
    execution.setProcessDefinition(this.getProcessDefinition(owner));
    return execution;
  }

  private synchronized ProcessDefinitionImpl getProcessDefinition(final Object owner) {
    if (this.processDefinition != null) {
      return this.processDefinition;
    }
    final Class< ? > ownerClass = owner.getClass();
    try {
      final Method method = ownerClass.getMethod("getProcessDefinition");
      this.processDefinition = (ProcessDefinitionImpl) method.invoke(null,
          (Object[]) null);
    } catch (final Exception e) {
      throw new RuntimeException("couldn't get process definition for " + owner);
    }

    return this.processDefinition;
  }

  public void nullSafeSet(final PreparedStatement st, final Object owner, final int index) throws SQLException {
    if (owner != null) {
      final ExecutionImpl execution = (ExecutionImpl) owner;
      final String nodeName = execution.getNode().getName();
      ExecutionType.LOG.trace("binding 'execution-state{" + nodeName + "}' to parameter: "
          + index);
      st.setString(index, nodeName);
    }
  }

  // for dirty checking ?

  public Object deepCopy(final Object object) {
    if (object == null) {
      return null;
    }

    final ExecutionImpl original = (ExecutionImpl) object;

    final NodeImpl node = new NodeImpl();
    node.setName(original.getNode().getName());

    final ExecutionImpl copy = new ExecutionImpl();
    copy.setNode(node);

    return copy;
  }

  public boolean equals(final Object arg0, final Object arg1) {
    if ((arg0 == null) || (arg1 == null)) {
      return false;
    }

    final ExecutionImpl execution0 = (ExecutionImpl) arg0;
    final ExecutionImpl execution1 = (ExecutionImpl) arg1;

    final String nodeName0 = execution0.getNode().getName();
    final String nodeName1 = execution1.getNode().getName();

    return nodeName0.equals(nodeName1);
  }

  public int hashCode(final Object object) {
    return object.hashCode();
  }

  public boolean isMutable() {
    return true;
  }

  public Class< ? > returnedClass() {
    return Execution.class;
  }

  // merge functionality //////////////////////////////////////////////////////

  public Object replace(final Object arg0, final Object arg1, final Object arg2) {
    return null;
  }

  // serialization for cache //////////////////////////////////////////////////

  public Object assemble(final Serializable arg0, final Object arg1) {
    return null;
  }

  public Serializable disassemble(final Object arg0) {
    return null;
  }
}
