/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import javax.transaction.Status;
import javax.transaction.Synchronization;

import org.ow2.orchestra.pvm.internal.log.Log;

/**
 * listener that can be registered as a listener to the transaction to notify
 * the jobImpl executor of added jobs so that the dispatcher thread can wake up.
 *
 * @author Tom Baeyens
 */
public class JobAddedNotification implements Synchronization {

  private static final Log LOG = Log.getLog(JobAddedNotification.class.getName());

  private final JobExecutor jobExecutor;

  public JobAddedNotification(final JobExecutor jobExecutor) {
    this.jobExecutor = jobExecutor;
  }

  public void afterCompletion(final int status) {
    if (status == Status.STATUS_COMMITTED) {
      JobAddedNotification.LOG.trace("notifying jobImpl executor of added message");
      this.jobExecutor.jobWasAdded();
    }
  }

  public void beforeCompletion() {
  }

  @Override
  public String toString() {
    return "job-added-notification";
  }
}
