/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.pvm.internal.jobexecutor.jdk;

import java.util.Collection;

import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.pvm.internal.log.Log;

/**
 * {@link AbstractDispatcherThread} implementation for using with {@link java.util.concurrent.ExecutorService}.
 * (Part of {@link JdkJobExecutor}).
 *
 * @author Guillaume Porcher
 */
public class JdkDispatcherThread extends AbstractDispatcherThread {

  private static final Log LOG = Log.getLog(JdkDispatcherThread.class.getName());

  private final JdkJobExecutor jobExecutor;

  JdkDispatcherThread(final JdkJobExecutor jobExecutor) {
    this(jobExecutor, "DispatcherThread");
  }

  JdkDispatcherThread(final JdkJobExecutor jobExecutor, final String name) {
    super(name);
    this.jobExecutor = jobExecutor;
  }

  @Override
  public JdkJobExecutor getJobExecutor() {
    return this.jobExecutor;
  }

  @Override
  protected void putAcquiredJobDbidsOnQueue(final Collection<JobImpl<?>> acquiredJobDbids) {
    JdkDispatcherThread.LOG.debug("pushing jobs on the queue " + acquiredJobDbids);
    this.jobExecutor.getExecutorService().submit(new JobExecutorTask(this.jobExecutor.getCommandExecutor(), acquiredJobDbids));
    JdkDispatcherThread.LOG.trace("jobs " + acquiredJobDbids + " were put on the queue");
  }

}
