package org.ow2.orchestra.pvm.internal.lob;

import java.sql.SQLException;

import org.hibernate.Hibernate;
import org.ow2.orchestra.pvm.PvmException;

public class BlobStrategyBlob implements BlobStrategy {

  public void set(byte[] bytes, Blob blob) {
    if (bytes != null) {
      blob.setBlob(Hibernate.createBlob(bytes));
    }
  }

  public byte[] get(Blob blob) {
    java.sql.Blob sqlBlob = blob.getBlob();
    if (sqlBlob != null) {
      try {
        return sqlBlob.getBytes(1, (int) sqlBlob.length());
      } catch (SQLException e) {
        throw new PvmException("couldn't extract bytes out of blob", e);
      }
    }
    return null;
  }
}
