package org.ow2.orchestra.pvm.internal.lob;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClobStrategyChopped implements ClobStrategy {

  private static final int CHOP_SIZE = 1024;

  public char[] get(final Clob clob) {
    return this.glue(clob.getChops());
  }

  public void set(final char[] chars, final Clob clob) {
    clob.setChops(this.chop(chars));
  }

  public List<String> chop(final char[] chars) {
    List<String> chops = null;
    if ((chars != null) && (chars.length > 0)) {
      chops = new ArrayList<String>();
      int index = 0;
      while ((chars.length - index) > ClobStrategyChopped.CHOP_SIZE) {
        final String chop = new String(chars, index, ClobStrategyChopped.CHOP_SIZE);
        chops.add(chop);
        index += ClobStrategyChopped.CHOP_SIZE;
      }
      // add remainder chop
      final String chop = new String(chars, index, chars.length - index);
      chops.add(chop);
    }
    return chops;
  }

  public char[] glue(final List<String> chops) {
    if (chops != null) {
      final StringWriter writer = new StringWriter();

      final Iterator<String> iter = chops.iterator();
      while (iter.hasNext()) {
        writer.write(iter.next());
      }

      return writer.toString().toCharArray();
    }

    return null;
  }
}
