/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.util.Clock;
import org.ow2.orchestra.pvm.internal.util.EqualsUtil;
import org.ow2.orchestra.pvm.model.Comment;

public class CommentImpl implements Serializable, Comment {

  private static final long serialVersionUID = 1L;

  protected long dbid;
  protected int dbversion;
  protected String userId = null;
  protected Date time = null;
  protected String message = null;
  protected CommentImpl parent;
  protected List<CommentImpl> comments = null;

  public CommentImpl() {
  }

  public CommentImpl(final String message) {
    this.message = message;
    this.time = Clock.getCurrentTime();

    final Environment environment = Environment.getCurrent();
    if (environment != null) {
      this.userId = environment.getUserId();
    }
  }

  // replies //////////////////////////////////////////////////////////////////

  public Comment createComment(final String message) {
    if (message == null) {
      throw new PvmException("message is null");
    }
    if (this.comments == null) {
      this.comments = new ArrayList<CommentImpl>();
    }
    final CommentImpl reply = new CommentImpl(message);
    this.comments.add(reply);
    return reply;
  }

  public void removeComment(final Comment comment) {
    if (comment == null) {
      throw new PvmException("reply is null");
    }
    if (this.comments != null) {
      if (this.comments.remove(comment)) {
        ((CommentImpl) comment).setParent(null);
      }
    }
  }

  public Comment getParent() {
    return this.parent;
  }

  public void setParent(final CommentImpl parent) {
    this.parent = parent;
  }

  @SuppressWarnings("unchecked")
  public List<Comment> getComments() {
    if (this.comments == null) {
      return Collections.emptyList();
    }
    return (List) this.comments;
  }

  public void setComments(final List<CommentImpl> replies) {
    this.comments = replies;
  }

  // equals ///////////////////////////////////////////////////////////////////
  // hack to support comparing hibernate proxies against the real objects
  // since this always falls back to ==, we don't need to overwrite the hashcode
  @Override
  public boolean equals(final Object o) {
    return EqualsUtil.equals(this, o);
  }

  @Override
  public int hashCode() {
    return super.hashCode();
  }
  // getters and setters //////////////////////////////////////////////////////

  public long getDbid() {
    return this.dbid;
  }

  public String getUserId() {
    return this.userId;
  }

  public String getMessage() {
    return this.message;
  }

  public Date getTime() {
    return this.time;
  }

  public void setUserId(final String userId) {
    this.userId = userId;
  }

  public void setTime(final Date time) {
    this.time = time;
  }

  public void setMessage(final String message) {
    this.message = message;
  }
}
