/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.listener.EventListener;
import org.ow2.orchestra.pvm.model.Event;

/**
 * @author Tom Baeyens
 */
public class EventImpl extends ProcessElementImpl implements Serializable,
    Event {

  private static final long serialVersionUID = 1L;

  protected String name;
  protected List<EventListenerReference> listenerReferences;

  @Override
  public String toString() {
    return this.name != null ? "event(" + this.name + ")" : "event";
  }

  // listener references //////////////////////////////////////////////////////

  public EventListenerReference createEventListenerReference() {
    if (this.listenerReferences == null) {
      this.listenerReferences = new ArrayList<EventListenerReference>();
    }
    final EventListenerReference activityReference = new EventListenerReference();
    this.listenerReferences.add(activityReference);
    return activityReference;
  }

  public EventListenerReference createEventListenerReference(
      final Descriptor descriptor) {
    final EventListenerReference eventListenerReference = this.createEventListenerReference();
    eventListenerReference.setDescriptor(descriptor);
    return eventListenerReference;
  }

  public EventListenerReference createEventListenerReference(
      final EventListener eventListener) {
    final EventListenerReference eventListenerReference = this.createEventListenerReference();
    eventListenerReference.set(eventListener);
    return eventListenerReference;
  }

  public EventListenerReference createEventListenerReference(final String expression) {
    final EventListenerReference eventListenerReference = this.createEventListenerReference();
    eventListenerReference.setExpression(expression);
    return eventListenerReference;
  }

  // getters and setters //////////////////////////////////////////////////////

  @Override
  public long getDbid() {
    return this.dbid;
  }

  public String getName() {
    return this.name;
  }

  public void setName(final String name) {
    this.name = name;
  }

  public List<EventListenerReference> getListenerReferences() {
    return this.listenerReferences;
  }

  public void setListenerReferences(
      final List<EventListenerReference> eventListenerReferences) {
    this.listenerReferences = eventListenerReferences;
  }
}
