/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.model;

import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;

public class ObjectReference<T> extends ProcessElementImpl {

  private static final long serialVersionUID = 1L;
  // private static final Log log = Log.getLog(ObjectReference.class.getName());

  protected String expression;
  protected String expressionLanguage;
  protected Descriptor descriptor;
  protected T object;

  public ObjectReference() {
  }

  public ObjectReference(final String expression) {
    this.expression = expression;
  }

  public ObjectReference(final Descriptor descriptor) {
    this.descriptor = descriptor;
  }

  public ObjectReference(final T object) {
    this.object = object;
  }

  @Override
  public String toString() {
    if (this.object != null) {
      return this.object.toString();
    }
    if (this.expression != null) {
      return this.expression;
    }
    if (this.descriptor != null) {
      return this.descriptor.toString();
    }
    return "unresolved reference";
  }

  public T get() {
    if (this.object != null) {
      return this.object;
    }
    if (this.expression != null) {
      return this.resolveValueExpression();
    }
    if (this.descriptor != null) {
      return this.constructFromDescriptor();
    }
    return null;
  }

  public void set(final T object) {
    this.object = object;
  }

  // object builders //////////////////////////////////////////////////////////

  protected T constructFromDescriptor() {
    return (T) WireContext.create(this.descriptor);
  }

  protected T resolveValueExpression() {
    return null;
  }

  protected T resolveMethodExpression(final Environment environment) {
    return null;
  }

  public void setDescriptor(final Descriptor descriptor) {
    this.descriptor = descriptor;
  }

  public Descriptor getDescriptor() {
    return this.descriptor;
  }

  public void setExpression(final String expression) {
    this.expression = expression;
  }

  public T getObject() {
    return this.object;
  }

  public void setObject(final T object) {
    this.object = object;
  }

  public String getExpression() {
    return this.expression;
  }
}
