/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.util.HashMap;
import java.util.Map;

import org.ow2.orchestra.pvm.model.Event;
import org.ow2.orchestra.pvm.model.ObservableElement;

/**
 * observable and visible process elements.
 *
 * @author Tom Baeyens
 */
public class ObservableElementImpl extends ProcessElementImpl implements
    ObservableElement {

  private static final long serialVersionUID = 1L;

  protected String name;
  protected String description;
  protected Map<String, EventImpl> events;

  // default parent is null ///////////////////////////////////////////////////

  public ObservableElementImpl getParent() {
    return null;
  }

  // events ///////////////////////////////////////////////////////////////////

  public EventImpl getEvent(final String eventName) {
    return this.events != null ? this.events.get(eventName) : null;
  }

  public boolean hasEvent(final String eventName) {
    return this.getEvent(eventName) != null;
  }

  /** event factory method that also establishes the bidirectional relation. */
  public EventImpl createEvent(final String eventName) {
    final EventImpl event = new EventImpl();
    event.setName(eventName);
    return this.addEvent(event);
  }

  /**
   * add an event to this processDefinition element.
   *
   * @throws NullPointerException
   *           if event is null.
   */
  public EventImpl addEvent(final EventImpl event) {
    if (this.events == null) {
      this.events = new HashMap<String, EventImpl>();
    }
    this.events.put(event.getName(), event);
    return event;
  }

  // getters and setters //////////////////////////////////////////////////////

  public String getName() {
    return this.name;
  }

  public void setName(final String name) {
    this.name = name;
  }

  public String getDescription() {
    return this.description;
  }

  public void setDescription(final String description) {
    this.description = description;
  }

  public Map<String, Event> getEvents() {
    return (Map) this.events;
  }

  public void setEvents(final Map<String, EventImpl> events) {
    this.events = events;
  }
}
