/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.io.Serializable;

import org.ow2.orchestra.pvm.internal.type.Type;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;

/**
 * a declaration of a variable.
 * 
 * The source properties denote how the variable gets initialized upon creation.
 * 
 * The destination properties indicate how information from the current scope
 * gets propagated back into the outer scope.
 * 
 * @author Tom Baeyens
 */
public class VariableDefinitionImpl implements Serializable {

  private static final long serialVersionUID = 1L;

  protected long dbid;
  protected int dbversion;

  protected String key;
  protected String description;

  protected String source;
  protected String sourceExpression;
  protected Descriptor sourceDescriptor;

  protected String destination;
  protected String destinationExpression;

  protected Type type;

  public Object getSourceValue(ExecutionImpl execution) {
    if (sourceDescriptor != null) {
      return WireContext.create(sourceDescriptor);
    }
    if (source != null) {
      return execution.getVariable(key);
    }
    if (sourceExpression != null) {
      // TODO add variable source expression resolution
      return null;
    }
    return null;
  }

  public Object getDestinationValue(ExecutionImpl execution) {
    if (destinationExpression != null) {
      // TODO add variable destination expression resolution
      return null;
    }
    if (key != null) {
      return execution.getVariable(key);
    }
    return null;
  }

  public long getDbid() {
    return dbid;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public String getSourceExpression() {
    return sourceExpression;
  }

  public void setSourceExpression(String sourceExpression) {
    this.sourceExpression = sourceExpression;
  }

  public Descriptor getSourceDescriptor() {
    return sourceDescriptor;
  }

  public void setSourceDescriptor(Descriptor sourceDescriptor) {
    this.sourceDescriptor = sourceDescriptor;
  }

  public String getDestination() {
    return destination;
  }

  public void setDestination(String destination) {
    this.destination = destination;
  }

  public String getDestinationExpression() {
    return destinationExpression;
  }

  public void setDestinationExpression(String destinationExpression) {
    this.destinationExpression = destinationExpression;
  }

  public Type getType() {
    return type;
  }

  public void setType(Type type) {
    this.type = type;
  }
}
