/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.script;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.script.Bindings;

import org.ow2.orchestra.pvm.env.Context;
import org.ow2.orchestra.pvm.env.Environment;

/**
 * @author Tom Baeyens
 */
public class EnvironmentBindings implements Bindings {

  protected String[] readContextNames;
  protected String writeContextName;
  protected Environment environment;

  public EnvironmentBindings(final String[] readContextNames, final String writeContextName) {
    this.readContextNames = readContextNames;
    this.writeContextName = writeContextName;

    this.environment = Environment.getCurrent();
  }

  public Object get(final Object key) {
    final Context context = this.getReadContext(key);
    if (context != null) {
      return context.get((String) key);
    }
    return null;
  }

  protected Context getReadContext(final Object key) {
    for (final String readContextName : this.readContextNames) {
      final Context readContext = this.environment.getContext(readContextName);
      if ((readContext != null) && (readContext.has((String) key))) {
        return readContext;
      }
    }
    return null;
  }

  public boolean containsKey(final Object key) {
    final Context context = this.getReadContext(key);
    return context != null;
  }

  public Object put(final String key, final Object value) {
    if (this.writeContextName == null) {
      return null;
    }
    final Context writeContext = this.environment.getContext(this.writeContextName);
    if (writeContext == null) {
      return null;
    }
    return writeContext.set(key, value);
  }

  public void putAll(final Map< ? extends String, ? extends Object> toMerge) {
    throw new UnsupportedOperationException();
  }

  public Object remove(final Object key) {
    throw new UnsupportedOperationException();
  }

  public void clear() {
    throw new UnsupportedOperationException();
  }

  public boolean containsValue(final Object value) {
    throw new UnsupportedOperationException();
  }

  public Set<java.util.Map.Entry<String, Object>> entrySet() {
    throw new UnsupportedOperationException();
  }

  public boolean isEmpty() {
    throw new UnsupportedOperationException();
  }

  public Set<String> keySet() {
    throw new UnsupportedOperationException();
  }

  public int size() {
    throw new UnsupportedOperationException();
  }

  public Collection<Object> values() {
    throw new UnsupportedOperationException();
  }
}
