/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.spring;

import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

/**
 * @author Tom Baeyens
 */
public class CommandTransactionCallback<T> implements TransactionCallback {

  private final Command<T> command;
  private final EnvironmentFactory environmentFactory;

  public CommandTransactionCallback(final Command<T> command,
      final EnvironmentFactory environmentFactory) {
    this.command = command;
    this.environmentFactory = environmentFactory;
  }

  public T doInTransaction(final TransactionStatus status) {
    final Environment environment = this.environmentFactory.openEnvironment();
    try {
      return this.command.execute(environment);
    } catch (final Exception e) {
      throw new RuntimeException("ooops", e);
    } finally {
      environment.close();
    }
  }

}
