/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.ow2.orchestra.pvm.internal.svc;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.session.MessageSession;

/**
 * @author Tom Baeyens
 */
public class AsyncCommandService implements CommandService {

  protected boolean propagateUserId = true;

  public <T> T execute(final Command<T> command) {
    final Environment environment = Environment.getCurrent();
    if (environment == null) {
      throw new PvmException("no environment for verifying authorization");
    }
    final MessageSession messageSession = environment.get(MessageSession.class);
    if (messageSession == null) {
      throw new PvmException(
          "no message session for executing command asynchronously");
    }
    final String userId = this.propagateUserId ? environment.getUserId() : null;
    messageSession.send(new AsyncCommandMessage(command, userId));
    return null;
  }

  public void setPropagateUserId(final boolean propagateUserId) {
    this.propagateUserId = propagateUserId;
  }
}
