package org.ow2.orchestra.pvm.internal.type;

import java.io.Serializable;

public class TypeMapping implements Serializable {

  private Matcher matcher;
  private Type type;

  private static final long serialVersionUID = 1L;

  public boolean matches(final String name, final Object value) {
    return this.matcher.matches(name, value);
  }

  @Override
  public String toString() {
    return "(" + this.matcher + "-->" + this.type + ")";
  }

  public void setMatcher(final Matcher matcher) {
    this.matcher = matcher;
  }

  public Type getType() {
    return this.type;
  }

  public void setType(final Type type) {
    this.type = type;
  }

  public Matcher getMatcher() {
    return this.matcher;
  }
}
