package org.ow2.orchestra.pvm.internal.type.variable;

import org.ow2.orchestra.pvm.internal.type.Variable;

/**
 * uses the cache in variable instance to store any object without persisting
 * it.
 */
public class UnpersistableVariable extends Variable {

  private static final long serialVersionUID = 1L;

  private Object value;

  @Override
  protected Object getObject() {
    return this.value;
  }

  @Override
  public boolean isStorable(final Object value) {
    return true;
  }

  @Override
  protected void setObject(final Object value) {
    this.value = value;
  }
}
